import QtQuick 1.0

Item {
  id:root

  property int horizontalSegmentWidth: width - (width / 10)
  property int horizontalSegmentHeight: Math.ceil(width / 10)

  property int verticalSegmentWidth: Math.ceil(width / 10)
  property int verticalSegmentHeight: (height - (horizontalSegmentHeight * 6)) / 2

  property color colorActive:'#ff0000'
  property color colorInactive:Qt.lighter(colorActive, 0.2);

  property int burnOutDuration: 100

  property alias s1: seg1.active
  property alias s2: seg2.active
  property alias s3: seg3.active
  property alias s4: seg4.active
  property alias s5: seg5.active
  property alias s6: seg6.active
  property alias s7: seg7.active

  property string pattern: '000000'

  onPatternChanged: {
    if(pattern.length != 7) {
      console.log('*** Pattern string length must equal 7!');
    }

    for(var i = 0; i < 7; i++) {
      root['s' + (i + 1)] = pattern[i] == '1';
    }
  }

  Led {
    id:seg1

    anchors.horizontalCenter:parent.horizontalCenter
    width:root.horizontalSegmentWidth;height:root.horizontalSegmentHeight

    burnOutDuration: root.burnOutDuration

    colorActive: root.colorActive
    colorInactive: root.colorInactive
  }

  Led {
    id:seg2

    anchors {horizontalCenter:seg1.left;top:seg1.bottom;topMargin:Math.ceil(verticalSegmentWidth / 2)}
    width:root.verticalSegmentWidth;height:root.verticalSegmentHeight

    burnOutDuration: root.burnOutDuration

    colorActive: root.colorActive
    colorInactive: root.colorInactive
  }

  Led {
    id:seg3

    anchors {horizontalCenter:seg1.right;top:seg1.bottom;topMargin:Math.ceil(verticalSegmentWidth / 2)}
    width:root.verticalSegmentWidth;height:root.verticalSegmentHeight

    burnOutDuration: root.burnOutDuration

    colorActive: root.colorActive
    colorInactive: root.colorInactive
  }

  Led {
    id:seg4

    anchors {horizontalCenter:parent.horizontalCenter;top:seg2.bottom;topMargin:Math.ceil(verticalSegmentWidth / 2)}
    width:root.horizontalSegmentWidth;height:root.horizontalSegmentHeight

    burnOutDuration: root.burnOutDuration

    colorActive: root.colorActive
    colorInactive: root.colorInactive
  }

  Led {
    id:seg5

    anchors {horizontalCenter:seg1.left;top:seg4.bottom;topMargin:Math.ceil(verticalSegmentWidth / 2)}
    width:root.verticalSegmentWidth;height:root.verticalSegmentHeight

    burnOutDuration: root.burnOutDuration

    colorActive: root.colorActive
    colorInactive: root.colorInactive
  }

  Led {
    id:seg6

    anchors {horizontalCenter:seg1.right;top:seg4.bottom;topMargin:Math.ceil(verticalSegmentWidth / 2)}
    width:root.verticalSegmentWidth;height:root.verticalSegmentHeight

    burnOutDuration: root.burnOutDuration

    colorActive: root.colorActive
    colorInactive: root.colorInactive
  }

  Led {
    id:seg7

    anchors {horizontalCenter:parent.horizontalCenter;top:seg5.bottom;topMargin:Math.ceil(verticalSegmentWidth / 2)}
    width:root.horizontalSegmentWidth;height:root.horizontalSegmentHeight

    burnOutDuration: root.burnOutDuration

    colorActive: root.colorActive
    colorInactive: root.colorInactive
  }
}

