import QtQuick 1.0

import 'LedNumericDigit.js' as Led

Item {
  id:root

  property alias digits: repeater.model
  property alias spacing: row.spacing

  property int digitWidth: 250
  property int digitHeight: digitWidth * 2

  property color colorActive:'#ff0000'
  property color colorInactive:Qt.lighter(colorActive, 0.2);

  property int burnOutDuration: 100

  property int value: 0

  width:childrenRect.width;height:childrenRect.height

  function __update() {
    for(var i = 0; i < row.children.length - 1; i++) {
      var seg = row.children[row.children.length - 2 - i];
      var pow = Math.pow(10, i);
      var val = Math.floor(value / pow % 10);

      if(seg.pattern) seg.pattern = value >= pow ? Led.DIGITS[val] : Led.ALL_OFF;
    }
    
    if(row.children.length > 1 && value == 0) row.children[row.children.length - 2].pattern = Led.DIGITS[0];
  }

  onValueChanged: __update();
  onChildrenChanged: __update();

  Component.onCompleted: __update();

  Row {
    id:row

    spacing:80

    Repeater {
      id:repeater

      model:4

      delegate: LedNumericDigit {
        width:root.digitWidth
        height:root.digitHeight

        colorActive:root.colorActive
        colorInactive:root.colorInactive

        burnOutDuration:root.burnOutDuration
      }
    }
  }
}

