import QtQuick 1.0
import Qt.labs.shaders 1.0

Rectangle {
  id:main

  width:display.width + 100;height:display.height + 50

  color:'black'


  Timer {
    id:timer

    repeat:true
    running:true
    triggeredOnStart:true
    interval:1000

    onTriggered: {
      var date = new Date();

      hours.value = 100 + date.getHours();
      minutes.value = 100 + date.getMinutes();

      spacer1.active = !spacer1.active
      spacer2.active = !spacer2.active
    }
  }

  Row {
    id:display

    anchors.centerIn:parent
    spacing:40

    property color colorActive:'#00ffff'

    Behavior on opacity {NumberAnimation {duration:750}}

    LedNumericDisplay {
      id:hours

      digits:2
      value:0

      colorActive:display.colorActive;
      colorInactive:Qt.lighter(colorActive, 0.1);

      burnOutDuration:250
    }

    Column {
      anchors.verticalCenter:parent.verticalCenter
      spacing: 40

      Led {
        id:spacer1
        width:25;height:width

        colorActive:display.colorActive;
        colorInactive:Qt.lighter(colorActive, 0.1);

        burnOutDuration:100
      }

      Led {
        id:spacer2
        width:25;height:width

        colorActive:display.colorActive;
        colorInactive:Qt.lighter(colorActive, 0.1);

        burnOutDuration:100
      }
    }

    LedNumericDisplay {
      id:minutes

      digits:2
      value:0

      colorActive:display.colorActive;
      colorInactive:Qt.lighter(colorActive, 0.1);

      burnOutDuration:250
    }
  }

  GaussianBlur {
    id: blur

    anchors {fill:display;margins:-radius}

    radius:10

    source: ShaderEffectSource {
      sourceItem:display
      hideSource:false
      sourceRect:Qt.rect(-blur.radius, -blur.radius, display.width + blur.radius * 2, display.height + blur.radius * 2)
    }
  }
}

