/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QML Shaders plugin of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 1.0
import Qt.labs.shaders 1.0

 Rectangle {
     width: 300
     height: 300

     Text {
         id: textLabel
         text: "Hello World"
         anchors.centerIn: parent
         font.pixelSize: 48
     }

     ShaderEffectItem {
         objectName: "effectItem"
         property variant source: ShaderEffectSource { objectName: "effectSource"; sourceItem: textLabel; hideSource: true }
         property real wiggleAmount: 0.01
         anchors.fill: textLabel

         SequentialAnimation on wiggleAmount {
             loops: Animation.Infinite
             NumberAnimation { to: -0.01; duration: 500 }
             NumberAnimation { to: 0.01; duration: 500 }
         }

         fragmentShader: "
         varying highp vec2 qt_TexCoord0;
         uniform sampler2D source;
         uniform highp float wiggleAmount;
         void main(void)
         {
             highp vec2 wiggledTexCoord = qt_TexCoord0;
             wiggledTexCoord.s += sin(4.0 * 3.141592653589 * wiggledTexCoord.t) * wiggleAmount;
             gl_FragColor = texture2D(source, wiggledTexCoord.st);
         }
         "
     }
 }
